#!/bin/sh

## This is a script of commands to launch after H.323 application had crashed,
## and before reload it again.
##
## Actions:
## * Remove DHCP client instance
## * Clean shared resources, created by Mapusoft
## * Reload Bluetooth process
## * Reload VPN

echo Start preparations...

## Remove DHCP client instance
if [ -f /var/run/dhclient*.pid ]; then
	killall dhclient
	rm /var/run/dhclient*.pid
fi

## Remove wpa_supplicant (in dot1x case) instance
if [ -f /usr/sbin/wpa_supplicant ]; then
	killall wpa_supplicant
	rm /etc/wpa_supplicant_pid
fi

## Clean shared resources, created by Mapusoft
/AvayaDir/lib/cleanup.pl

## Stop the Bluetooth process
if [ -f /bin/bt_bsa.sh ]; then
	/bin/bt_bsa.sh stop
fi

## Reload VPN
echo "VPN cleanup"
ifconfig eth0:0 down
rm /tmp/vpn-virtual-ip-active
rmmod outgoinghook
rmmod incominghook
kill -9 `ps x | grep nfnetlinkd | grep -v grep | awk '{print$1}'` 
rm /tmp/server
/h323VPN/nfnetlinkd &
sleep 1
/etc/init.d/sshd stop
## end
echo Done preparations.
