#!/bin/sh
export PATH=/usr/sbin:/sbin:$PATH
export LD_PRELOAD=/lib/libc.so.6
#timings for sar
end_time=$(date +%H:%M:%S)
start_time=$(awk 'BEGIN { print strftime("%H:%M:%S",systime()-60*60); exit }')
temp_file=$(mktemp /tmp/report_tmp.XXXXXX)
audio_report_file=/tmp/Audio_Report.tar.gz
memory_zip_filename=/var/log/memory_exhausted.tgz
scr_file=$(dmesg | grep "frame buffer" | awk -F: '{printf("%s %s",$3,$4);}' | awk '{printf("screenshot_%s_%s_32.raw",$1,$3);}')

if [ "${USER}" == root ]; then
        zip_file=/tmp/phone_report.tar.gz
else
        zip_file=/tmp/phone_report_${USER}.tar.gz
fi

sds_files="/var/log/* /tmp/logs/avaya_phone.log /tmp/logs/96x1_dump $0 /AvayaDir/H323/application/logevt /AvayaDir/H323/application/logrst /AvayaDir/H323/application/logstartup $audio_report_file"

ipo_files="/var/log/* /tmp/logs/avaya_phone.log /tmp/logs/96x1_dump $0 /AvayaDir/H323/application/logevt /AvayaDir/H323/application/logrst /AvayaDir/H323/application/logstartup $audio_report_file"

sds_files_small="/tmp/logs/avaya_phone.log /tmp/logs/96x1_dump $0 /AvayaDir/H323/application/logevt /AvayaDir/H323/application/logrst /AvayaDir/H323/application/logstartup"

ipo_files_small="/tmp/logs/avaya_phone.log $0 /AvayaDir/H323/application/logevt /AvayaDir/H323/application/logrst /AvayaDir/H323/application/logstartup"

if [ -r "$audio_report_file" ] ; then
	crash_report_files="/tmp/logs/avaya_phone.log /tmp/logs/96x1_dump /AvayaDir/H323/application/logevt /AvayaDir/H323/application/logrst /AvayaDir/H323/application/logstartup $audio_report_file"
else
	crash_report_files="/tmp/logs/avaya_phone.log /tmp/logs/96x1_dump /AvayaDir/H323/application/logevt /AvayaDir/H323/application/logrst /AvayaDir/H323/application/logstartup"
fi
crash=0

report_generate_screenshot()
{
    cat /dev/fb0 > /tmp/${scr_file}
    touch /tmp/${scr_file}
}

report_print()
{
if [ -z "$report_file" ]; then
        echo $*
    else
        echo $* >>$report_file
        fi
}

run_command()
{

    desc=$1

    shift
    command=$*
    report_print
    report_print "############## Category : $category  ##############"
    report_print "############## Description : $desc  ##############"
    report_print "############## Command : $command  ##############"
    report_print "############## Output ##############"
    report_print
    if [ -z "$report_file" ]; then
        $command 2>&1
    else
        $command 2>&1 | cat >> $report_file
        fi
    report_print
    report_print "############## End ##############"

}



display_reset_cause()
{
	echo " " >> $report_file
	echo "#######################    Kernel Reset Cause    ###########################" >> $report_file
	echo "##  Possible STICKYBITS register values:                                  ##" >> $report_file
	echo "##    0x00000080: Plug-out                                                ##" >> $report_file
	echo "##    0x00000480: Linux / application reboot                              ##" >> $report_file
	echo "##    0x00000880: HW watchdog reboot                                      ##" >> $report_file
	echo "## From /tmp/last_reset_cause.txt (check /var/log/* for previous resets): ##" >> $report_file
	cat  /tmp/last_reset_cause.txt >> $report_file 
	echo "############################################################################" >> $report_file
}


system_command()
{
    category=System
    run_command  'System Data' 'date'
    run_command  'System Identification' 'uname -a'
    run_command  'System uptime information' 'uptime'
    run_command  'CPU Information' 'cat /proc/cpuinfo'
    run_command 'Memory information' 'free'
    run_command  'Memfree' 'cat /proc/meminfo'
    run_command  'Virtual memory statistics' 'cat /proc/vmstat'
    run_command  'Mounted FS information and Usage' 'df -h'
    run_command 'Loaded modules' 'lsmod'
    run_command 'System interrupts' 'cat /proc/interrupts'
    run_command 'Heartbeat status' 'cat /tmp/heartbeat.txt'
    run_command 'Platform Configuration' 'cat /nvdata/platform.cfg'
    run_command 'Local Hardware Version' 'cat /AvayaDir/H323/application/HardwareVersion.txt'
    run_command '46xxsettings Configuration' 'cat /tmp/settings_backup.txt'
    run_command 'Soft Reset Number' 'cat /tmp/restartNumber.txt'
    run_command 'Process status' 'ps -eLo pid,tid,class,rtprio,ni,pri,psr,pcpu,stat,wchan:14,comm'
    run_command 'TOP Status' 'top -n 1 -b'
    run_command 'File NR' 'cat /proc/sys/fs/file-nr'
    run_command 'Semaphore and Queue status' 'ipcs'
    run_command  'System boot log' 'dmesg'
    run_command 'GPIO State Information' 'cat /sys/kernel/debug/gpio'
    run_command  'Core dump files' 'ls -al /data/crash/'
    display_reset_cause
    ls /tmp/logs
    kill -2 $(ps x | grep "/AvayaDir/H323/application/96" | grep -v gre | awk '{print $1}')
    if [ ! -r "/tmp/logs/96x1_dump" ]; then
        touch /tmp/logs/96x1_dump
    fi

}

network_command()
{
    category=Network
    run_command  'Configured network interfaces information' 'ifconfig -a'
    run_command  'Configured Routing table' 'route -n'
    run_command  'Configured DNS servers information' 'cat /etc/resolv.conf'
    run_command  'Static Host configuration' 'cat /etc/hosts'
    run_command 'Network statistics' 'netstat -an'
    run_command  'Configured Firewall rules' 'iptables -L -n'
    run_command 'Netowrk interface statistics' 'ethtool -S eth0'
    run_command 'Network configuration ' 'ethtool eth0'
    run_command 'DHCP Information' 'cat /var/lib/dhclient/dhclient.leases'
    run_command 'Displays the Address Resolution table' 'eth arl table show'
    run_command 'Displays the ARP table' 'arp -a'
    run_command 'Display the link speed of port 0' 'eth speed 0 ?'
    run_command 'Display the link speed of port 1' 'eth speed 1 ?'
}

audio_command()
{
    category=Audio
        run_command 'Audio statistics EPT buffer statistics : buffers' 'cat /proc/ept/bufErrStats'
        run_command 'Audio statistics EPT Active audio codecs'  'cat /proc/ept/activeAudioCodec'
        run_command 'Audio statistics EPT dev' 'cat /proc/ept/stream_dev'
        run_command 'Audio statistics EPT pve stats ' 'cat /proc/ept/pvestats'
        run_command 'Audio statistics EPT pve statate ' 'cat /proc/ept/pvestate'
        run_command 'Audio statistics EPT RTP stats' 'cat /proc/ept/rtpstats'
        run_command 'Audio statistics EPT Audio Sync' 'cat /proc/ept/audsync'
        run_command 'Audio statistics EPT Message Pool' 'cat /proc/ept/msgpool'
        run_command 'Audio statistics EPT HW CryptoAuthEnable' 'cat /proc/ept/hwCryptoAuthEnable'
        run_command 'Audio statistics EPT HW CryptoCipherEnable' 'cat /proc/ept/CryptoCipherEnable'
        run_command 'Audio statistics EPT NET stats' 'cat /proc/ept/netstats'
        run_command 'Audio statistics EPT Perfsum' 'cat /proc/ept/perfsum'
        run_command 'Audio statistics AMXR' 'cat /proc/amxr'
        run_command 'Audio statistics DMA Channels' 'cat /proc/dma/channels'
        run_command 'Audio statistics DMA Devices' 'cat /proc/dma/devices'
        run_command 'Audio statistics DMA Mem Type' 'cat /proc/dma/mem-type'
        run_command 'Audio statistics HAL Audio' 'cat /proc/halaudio'
        run_command 'Audio statistics APM amp0' 'cat /proc/apm/apm0'
        run_command 'Audio statistics APM amp1' 'cat /proc/apm/apm1'
        run_command 'Audio statistics PCM pcm0 ' 'cat /proc/pcm/pcm0'
        run_command 'Audio statistics PXCON' '/bin/pxcon /AvayaDir/lib/AudioConfiguration.pxcon'

}

memory_command()
{
	category=Memory
	cat /tmp/tmp_usage | awk '{print "Used:",$1,"Bytes"}' > /tmp/tmp_usageh
	run_command 'TMP Folder Memory Information' 'cat /tmp/tmp_usageh'
	run_command 'TMP Files List' 'ls -laR /var/tmp'
	rm /tmp/tmp_usageh
}

knllog()
{
        echo "Dumping knllog to /tmp/var/knllog.txt"
        echo 1 > /proc/sys/knllog/enable
        echo 500000 > /proc/sys/knllog/entries
        echo 0x1f > /proc/sys/knllog/irq_sched_enable
        echo 1 > /proc/sys/knllog/clear; sleep 3; echo 1 > /proc/sys/knllog/dump
        echo "Finished......Bye"

}

help()
{
    echo "$0 - Utility to prepare and output phone system information"
    echo "Without an options will dump all the information to stdout"
    echo "Options:"
    echo "-l - Limit report file size KB"
    echo "-i - Run in IPO environment"
    echo "-k - interupt log of last 3 seconds"
    echo "-a - Enable audio information. Disabled by default"
    echo "-h - This help"

}


list_modules()
{
    if [ $sys_flag -eq 1 ]; then
        echo "Module : System Information enabled"
    fi
    if [ $net_flag -eq 1 ]; then
        echo "Module : Network Information enabled"
    fi
    if [ $audio_flag -eq 1 ]; then
        echo "Module : Audio Information enabled"
    fi
    if [ $memory_flag -eq 1 ]; then
        echo "Module : Memory Information enabled"
    fi
}

set_default_flags()
{

        sys_flag=1
        net_flag=1
        audio_flag=0
        memory_flag=0
        zip_flag=1
        report_file=$(mktemp -t)
}



run_commands_by_flags()
{

    if [ "$sys_flag" == "1" ]; then
        echo "Generating report for System information"
        system_command
    fi
    if [ "$net_flag" == "1" ]; then
        echo "Generating report for Network information"
        network_command
    fi
    if [ "$audio_flag" == "1" ]; then
        echo "Generating report for Audio information"
        audio_command
    fi
    if [ "$memory_flag" == "1" ]; then
        echo "Generating report for Memory information"
        memory_command
    fi

     echo "All reports have been generated"

}

zip_files()
{
        echo "Generating Avaya Phone report archive"
        date=$(date +%k%M%d%m%g|sed 's/ //')
        run_commands_by_flags
        mv $report_file /tmp/REPORT.txt
        if [ $audio_flag -eq 1 ]; then
        	echo "Packaging audio information into $audio_report_file ..."
        	sleep 3  ## wait enough time for all files to finish writing
        	tar -cvzf $audio_report_file /tmp/REPORT.txt /tmp/logs/96x1_dump /tmp/logs/avaya_phone.log /tmp/knllog.txt
        	rm -rf /tmp/REPORT.txt /tmp/report_* /tmp/tmp.* /tmp/knllog.txt
	      	echo "Done."
   			exit 0
    	fi
        rm -rf $zip_file
        temp_file=$(mktemp -t)

        if [ -z "$is_ipo" ]; then
            file_list=$(find $sds_files 2>/dev/null)
        else
            file_list=$(find $ipo_files 2>/dev/null)
        fi

        if ! tar -C /tmp -zcvf $temp_file $file_list REPORT.txt >/dev/null 2>&1; then
            echo "Error: Failed to prepare $zip_file archive"
            exit 1
        fi

       local size=$(ls  -1 -l $temp_file | awk '{print $3}')
       if [ ! -z "$total_size" ] && [ $size -gt $total_size ]; then
           if [ -z "$is_ipo" ]; then
               file_list=$(find $sds_files_small 2>/dev/null)
           else
               file_list=$(find $ipo_files_small 2>/dev/null)
           fi

           report_print "!!!!!!!!!!!! FILES WHERE REMOVED DUE TO SIZE LIMITATIONS!!!!!!!!!!!!!!!!!!!!!!!!!!"

           rm -rf $temp_file

           if ! tar -C /tmp -zcvf $temp_file $file_list REPORT.txt >/dev/null 2>&1; then
               echo "Error: Failed to prepare $zip_file archive"
               exit 1
           fi

        fi

		if [ "${memory_flag}" -eq "1" ]; then
			zip_file=$memory_zip_filename
		fi
        mv $temp_file $zip_file

    rm -rf /tmp/REPORT.txt /tmp/SAR_ALL_REPORT.txt

   echo "Avaya Phone report archive have been generated"
   echo "Archive name on Avaya Phone :  $zip_file"



}

crash_report()
{

    run_commands_by_flags
    mv $report_file /tmp/REPORT.txt
    report_generate_screenshot #generate screnshot

    if ! tar -C /tmp -zcvf $temp_file $crash_report_files REPORT.txt $scr_file >/dev/null 2>&1; then
        echo "Error: Failed to prepare $zip_file archive"
        exit 1
    fi

    crash_filename=/var/log/wd_crash.tgz
    mv $temp_file $crash_filename
    logrotate -f /etc/logrotate.conf
    echo "Crash report has been generated. File: $crash_filename"


}

args=`getopt -o hakimcl:  -n $0 -- "$@"`


set_default_flags

if [ $? != 0 ] ; then echo "Error parsing cmd args" >&2 ; usage ;exit 1 ; fi

eval set -- "$args"

while true
do
case $1 in

      -h )
          help
          exit 1
          ;;

        -a )
        audio_flag=1
        shift
        ;;

      -k)
          knllog
          exit 1
          ;;
    -i)
          is_ipo=1
          shift
          ;;
    -m)
        memory_flag=1
        shift
        ;;
    -l)
	  total_size=$2
	  shift 2
          ;;
    -c)
          crash=1
          shift
          ;;
      --)
        break
        ;;
      *  )
          echo "No such option : --$1--"
          help
          exit 1
          ;;
  esac
done

if [ "${memory_flag}" -eq "1" ]; then
	logrotate -f /etc/logrotate.conf
fi
if [ "${crash}" -ne "1" ]; then #regular zipped report
    zip_files
else
    crash_report
fi
if [ -f /tmp/logs/96x1_dump ]; then
    rm /tmp/logs/96x1_dump
fi

